<?php
/**
 * MyBB 1.4 Advanced Quick Reply Form Plugin
 * Copyright © 2008 Phenomenon, All Rights Reserved
 *
 * Based on DragonFevers MyCode to Quick Reply modification.
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("admin_config_settings_begin", "advancedquickreplyform_admin_config_settings_begin");
$plugins->add_hook("admin_config_settings_change_commit", "advancedquickreplyform_admin_config_settings_change_commit");
$plugins->add_hook("showthread_start", "advancedquickreplyform_showthread_start");

function advancedquickreplyform_info()
{
	global $lang;
	
	$lang->load("forum_advancedquickreplyform", false, true);
	
	return array(
		"name" => $lang->advancedquickreplyform,
		"description" => $lang->advancedquickreplyform_desc,
		"website" => "http://www.force-opponents.de",
		"author" => "Phenomenon",
		"authorsite" => "http://www.force-opponents.de",
		"version" => "1.0.3",
		"guid" => "7eb0a475a40bd37fde4f2ec62e68a68d",
		"compatibility" => "16*"
	);
}

function advancedquickreplyform_install()
{
	global $db;
	
	// Remove old installation to avoid duplicates
	advancedquickreplyform_uninstall();
	
	$query = $db->simple_select("settinggroups", "COUNT(*) as rows");
	$rows = $db->fetch_field($query, "rows");
	
	$insertarray = array(
		"name" => "advancedquickreplyform",
		"title" => "هاك الرد السريع المتقدم",
		"description" => "اعدادات الهاك لضبطه بما يناسبك",
		"disporder" => $rows + 1,
		"isdefault" => 0,
	);
	
	$db->insert_query("settinggroups", $insertarray);
	$gid = $db->insert_id();
	
	$insertarray = array(
		"name" => "quickreplybbcodeinserter",
		"title" => "تفعيل محرر MYCODE",
		"description" => "تفعيل هذا سيقوم بتفعيل ظهور ازرار المحرر ويفضل تفعيله.",
		"optionscode" => "onoff",
		"value" => 1,
		"disporder" => 0,
		"gid" => $gid
	);
	
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		"name" => "quickreplysmilieinserter",
		"title" => "تفعيل ايقونات الابتسامات",
		"description" => "لتفعيل الايقونات المصغره بجوار المحرر بشكل انيق يفضل تفعيله",
		"optionscode" => "onoff",
		"value" => 1,
		"disporder" => 1,
		"gid" => $gid
	);
	
	$db->insert_query("settings", $insertarray);
	
	rebuild_settings();
}

function advancedquickreplyform_is_installed()
{
	global $db;
	
	$query = $db->simple_select("settinggroups", "gid", "name = 'advancedquickreplyform'");
	
	if($db->num_rows($query))
	{
		return true;
	}
	
	return false;
}

function advancedquickreplyform_activate()
{
	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	find_replace_templatesets("showthread_quickreply", "#".preg_quote("{\$closeoption}</span>")."#i", "{\$closeoption}</span><br />{\$clickablesmilies}");
	find_replace_templatesets("showthread_quickreply", "#rows=\"8\"#i", "rows=\"".advancedquickreplyform_rows()."\"");
	find_replace_templatesets("showthread_quickreply", "#</textarea>#i", "</textarea>\n{\$codebuttons}");
}

function advancedquickreplyform_deactivate()
{
	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	find_replace_templatesets("showthread_quickreply", "#".preg_quote("<br />{\$clickablesmilies}")."#i", "", 0);
	find_replace_templatesets("showthread_quickreply", "#rows=\"\d+\"#i", "rows=\"8\"", 0);
	find_replace_templatesets("showthread_quickreply", "#".preg_quote("\n{\$codebuttons}")."#i", "", 0);
}

function advancedquickreplyform_uninstall()
{
	global $db;
	
	$db->delete_query("settinggroups", "name = 'advancedquickreplyform'");
	$db->write_query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN('quickreplybbcodeinserter', 'quickreplysmilieinserter')");
	
	rebuild_settings();
}

function advancedquickreplyform_admin_config_settings_begin()
{
	global $mybb, $lang;
	
	$lang->load("forum_advancedquickreplyform", false, true);
}

function advancedquickreplyform_admin_config_settings_change_commit()
{
	global $mybb;
	
	// Check if we need to update the template
	foreach(array("bbcodeinserter", "smilieinserter", "quickreplybbcodeinserter", "quickreplysmilieinserter") as $key)
	{
		if(array_key_exists($key, $mybb->input['upsetting']))
		{
			require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
			
			find_replace_templatesets("showthread_quickreply", "#rows=\"\d+\"#i", "rows=\"".advancedquickreplyform_rows()."\"", 0);
			
			break;
		}
	}
}

function advancedquickreplyform_showthread_start()
{
	global $mybb, $forumpermissions, $thread, $fid, $forum, $codebuttons, $clickablesmilies;
	
	// Add MyCode and smilie inserter
	if($forumpermissions['canpostreplys'] != 0 && $mybb->user['suspendposting'] != 1 && ($thread['closed'] != 1 || is_moderator($fid)) && $mybb->settings['quickreply'] != 0 && $mybb->user['showquickreply'] != '0' && $forum['open'] != 0)
	{
		if($mybb->settings['quickreplybbcodeinserter'] != 0)
		{
			$codebuttons = build_mycode_inserter();
		}
		
		if($forum['allowsmilies'] != 0 && $mybb->settings['quickreplysmilieinserter'] != 0)
		{
			$clickablesmilies = build_clickable_smilies();
		}
	}
}

function advancedquickreplyform_rows()
{
	global $mybb;
	
	$rows = 8;
	
	if($mybb->settings['quickreplybbcodeinserter'] != 0 && $mybb->settings['bbcodeinserter'] != 0)
	{
		$rows = 12;
	}
	
	if($mybb->settings['quickreplysmilieinserter'] != 0 && $mybb->settings['smilieinserter'] != 0)
	{
		$rows = 18;
	}
	
	return $rows;
}
?>